/*
 * Decompiled with CFR 0.152.
 */
package sybase.jdbc.sqlanywhere;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import sybase.jdbc.sqlanywhere.IColumnsResultSetMetaData;
import sybase.jdbc.sqlanywhere.IIResultSet;
import sybase.jdbc.sqlanywhere.IIStatement;
import sybase.jdbc.sqlanywhere.IResultSet;

public class IColumnsResultSet
extends IResultSet {
    private ResultSet rset;
    private IIResultSet irset;
    private final String[] extraColumns = new String[]{"SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
    private final int[] extraColumnsIndexes = new int[]{19, 20, 21, 22};
    private final int firstExtraColumnIndex = 19;
    private final int lastExtraColumnIndex = 22;

    public IColumnsResultSet(ResultSet resultSet, IIResultSet iIResultSet) {
        super(resultSet);
        this.rset = resultSet;
        this.irset = iIResultSet;
    }

    protected synchronized void finalize() {
        this.rset = null;
        this.irset = null;
    }

    private int extraColumnIndex(String string) {
        for (int i = 0; i < this.extraColumns.length; ++i) {
            if (string.compareToIgnoreCase(this.extraColumns[i]) != 0) continue;
            return this.extraColumnsIndexes[i];
        }
        return 0;
    }

    public int findColumn(String string) throws SQLException {
        int n = this.extraColumnIndex(string);
        if (n != 0) {
            return n;
        }
        return this.rset.findColumn(string);
    }

    private long checkNCHAR(int n, long l) {
        return l;
    }

    private short checkNCHAR(int n, short s) {
        return (short)this.checkNCHAR(n, (long)s);
    }

    private int checkNCHAR(int n, int n2) {
        return (int)this.checkNCHAR(n, (long)n2);
    }

    private Object checkNCHAR(int n, Object object) {
        if (n != 5) {
            return object;
        }
        if (object instanceof Short) {
            return new Short(this.checkNCHAR(n, (Short)object));
        }
        if (object instanceof Integer) {
            return new Integer(this.checkNCHAR(n, (Integer)object));
        }
        if (object instanceof Long) {
            return new Long(this.checkNCHAR(n, (Long)object));
        }
        return object;
    }

    private String checkNCHAR(int n, String string) {
        if (n != 5) {
            return string;
        }
        try {
            Long l = new Long(string);
            return Long.toString(this.checkNCHAR(n, l));
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public Array getArray(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getAsciiStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getBinaryStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public long getBlobLength(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0L;
        }
        return this.irset.getBlobLength(n);
    }

    public byte[] getBlobBytes(int n, int n2) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.irset.getBlobBytes(n, n2);
    }

    public Blob getBlob(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getBlob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return false;
        }
        return this.rset.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0;
        }
        return this.rset.getByte(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getBytes(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getClob(n);
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        return this.rset.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        return this.rset.getCursorName();
    }

    public Date getDate(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getDate(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0.0;
        }
        return this.rset.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0.0f;
        }
        return this.rset.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0;
        }
        return this.checkNCHAR(n, this.rset.getInt(n));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0L;
        }
        return this.checkNCHAR(n, this.rset.getLong(n));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rset.getMetaData();
        return new IColumnsResultSetMetaData((IIStatement)this.rset.getStatement(), resultSetMetaData);
    }

    public Object getObject(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.checkNCHAR(n, this.rset.getObject(n));
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.checkNCHAR(n, this.rset.getObject(n, map));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return 0;
        }
        return this.checkNCHAR(n, this.rset.getShort(n));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.checkNCHAR(n, this.rset.getString(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getTime(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        if (n >= 19 && n <= 22) {
            return null;
        }
        return this.rset.getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }
}

