/*
 * Decompiled with CFR 0.152.
 */
package sybase.jdbc.sqlanywhere;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import sybase.jdbc.sqlanywhere.IIPreparedStatement;
import sybase.jdbc.sqlanywhere.IResultSet;
import sybase.jdbc.sqlanywhere.IStatement;

public class IPreparedStatement
extends IStatement
implements PreparedStatement {
    private IIPreparedStatement pstmt;
    private Connection con = null;
    public boolean initFailed = false;

    public IPreparedStatement(PreparedStatement preparedStatement) {
        super(preparedStatement);
        try {
            this.pstmt = (IIPreparedStatement)preparedStatement;
        }
        catch (ClassCastException classCastException) {
            this.initFailed = true;
            return;
        }
        try {
            this.con = this.pstmt.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void finalize() {
        this.pstmt.release();
        this.con = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        IResultSet iResultSet = null;
        ResultSet resultSet = null;
        IIPreparedStatement iIPreparedStatement = this.pstmt;
        synchronized (iIPreparedStatement) {
            resultSet = this.pstmt.executeQuery();
        }
        if (resultSet != null) {
            iResultSet = new IResultSet(resultSet);
            if (iResultSet.initFailed) {
                iResultSet = null;
            } else {
                iResultSet.setStatementHandle(this);
            }
        }
        return iResultSet;
    }

    public int executeUpdate() throws SQLException {
        return this.pstmt.executeUpdate();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.pstmt.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.pstmt.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.pstmt.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.pstmt.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.pstmt.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.pstmt.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.pstmt.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.pstmt.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.pstmt.setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.pstmt.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.pstmt.setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.pstmt.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.pstmt.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.pstmt.setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.pstmt.setAsciiStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.pstmt.setUnicodeStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.pstmt.setBinaryStream(n, inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        this.pstmt.clearParameters();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.pstmt.setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.pstmt.setObject(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.pstmt.setObject(n, object);
    }

    public boolean execute() throws SQLException {
        return this.pstmt.execute();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.pstmt.setCharacterStream(n, reader, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.pstmt.setRef(n, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.pstmt.setBlob(n, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.pstmt.setClob(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.pstmt.setArray(n, array);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.pstmt.getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.pstmt.setDate(n, date, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.pstmt.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.pstmt.setTimestamp(n, timestamp, calendar);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.pstmt.setNull(n, n2, string);
    }

    public void addBatch() throws SQLException {
        this.pstmt.addBatch();
    }

    public void setBatchStringSize(int n, int n2) throws SQLException {
    }

    public int[] executeBatch() throws SQLException {
        return this.pstmt.internalExecuteBatch();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.pstmt.setURL(n, uRL);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.pstmt.getParameterMetaData();
    }
}

